/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.CompilerProgressListener;
import cc.arduino.packages.BoardPort;
import cc.arduino.packages.MonitorFactory;
import cc.arduino.packages.uploaders.SerialUploader;
import cc.arduino.view.GoToLineNumber;
import cc.arduino.view.StubMenuListener;
import cc.arduino.view.findreplace.FindReplace;
import com.jcraft.jsch.JSchException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.BadLocationException;
import jssc.SerialPortException;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import processing.app.AbstractMonitor;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.EditorConsole;
import processing.app.EditorHeader;
import processing.app.EditorLineStatus;
import processing.app.EditorStatus;
import processing.app.EditorTab;
import processing.app.EditorToolbar;
import processing.app.I18n;
import processing.app.Platform;
import processing.app.PreferencesData;
import processing.app.RunnerListener;
import processing.app.SerialException;
import processing.app.SerialNotFoundException;
import processing.app.SerialPlotter;
import processing.app.Sketch;
import processing.app.SketchController;
import processing.app.SketchFile;
import processing.app.Theme;
import processing.app.debug.RunnerException;
import processing.app.debug.TargetBoard;
import processing.app.forms.PasswordAuthorizationDialog;
import processing.app.helpers.DocumentTextChangeListener;
import processing.app.helpers.Keys;
import processing.app.helpers.OSUtils;
import processing.app.helpers.PreferencesMapException;
import processing.app.helpers.StringReplacer;
import processing.app.legacy.PApplet;
import processing.app.syntax.PdeKeywords;
import processing.app.syntax.SketchTextArea;
import processing.app.tools.MenuScroller;
import processing.app.tools.Tool;

public class Editor
extends JFrame
implements RunnerListener {
    public static final int MAX_TIME_AWAITING_FOR_RESUMING_SERIAL_MONITOR = 10000;
    final Platform platform;
    private JMenu recentSketchesMenu;
    private JMenu programmersMenu;
    private final Box upper;
    private ArrayList<EditorTab> tabs = new ArrayList();
    private int currentTabIndex = -1;
    final Base base;
    private static final String EMPTY = "                                                                                                                                                                                                               ";
    private static final int SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    static final KeyStroke WINDOW_CLOSE_KEYSTROKE = KeyStroke.getKeyStroke(87, SHORTCUT_KEY_MASK);
    static final int SHORTCUT_ALT_KEY_MASK = 8 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    boolean untitled;
    private PageFormat pageFormat;
    private JMenu fileMenu;
    private JMenu toolsMenu;
    private int numTools = 0;
    public static boolean avoidMultipleOperations = false;
    private final EditorToolbar toolbar;
    static JMenu toolbarMenu;
    static JMenu sketchbookMenu;
    static JMenu examplesMenu;
    static JMenu importMenu;
    private static JMenu portMenu;
    static volatile AbstractMonitor serialMonitor;
    static AbstractMonitor serialPlotter;
    final EditorHeader header;
    EditorStatus status;
    EditorConsole console;
    private JSplitPane splitPane;
    SketchController sketchController;
    Sketch sketch;
    EditorLineStatus lineStatus;
    private JPanel codePanel;
    private JMenuItem saveMenuItem;
    private JMenuItem saveAsMenuItem;
    private static boolean uploading;
    private JMenuItem undoItem;
    private JMenuItem redoItem;
    private FindReplace find;
    Runnable runHandler;
    Runnable presentHandler;
    private Runnable runAndSaveHandler;
    private Runnable presentAndSaveHandler;
    private UploadHandler uploadHandler;
    private UploadHandler uploadUsingProgrammerHandler;
    private Runnable timeoutUploadHandler;
    private Map<String, Tool> internalToolCache = new HashMap<String, Tool>();

    public Editor(Base ibase, File file, int[] storedLocation, int[] defaultLocation, Platform platform) throws Exception {
        super("Arduino");
        this.base = ibase;
        this.platform = platform;
        Base.setIcon(this);
        this.resetHandlers();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Editor.this.base.handleClose(Editor.this);
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                Editor.this.base.handleActivated(Editor.this);
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                LinkedList<Component> toolsMenuItemsToRemove = new LinkedList<Component>();
                for (Component menuItem : Editor.this.toolsMenu.getMenuComponents()) {
                    Object removeOnWindowDeactivation;
                    if (!(menuItem instanceof JComponent) || (removeOnWindowDeactivation = ((JComponent)menuItem).getClientProperty("removeOnWindowDeactivation")) == null || !Boolean.valueOf(removeOnWindowDeactivation.toString()).booleanValue()) continue;
                    toolsMenuItemsToRemove.add(menuItem);
                }
                for (Component menuItem : toolsMenuItemsToRemove) {
                    Editor.this.toolsMenu.remove(menuItem);
                }
                Editor.this.toolsMenu.remove(portMenu);
            }
        });
        this.buildMenuBar();
        Container contentPain = this.getContentPane();
        contentPain.setLayout(new BorderLayout());
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        contentPain.add((Component)pane, "Center");
        Box box = Box.createVerticalBox();
        this.upper = Box.createVerticalBox();
        if (toolbarMenu == null) {
            toolbarMenu = new JMenu();
            this.base.rebuildToolbarMenu(toolbarMenu);
        }
        this.toolbar = new EditorToolbar(this, toolbarMenu);
        this.upper.add(this.toolbar);
        this.header = new EditorHeader(this);
        this.upper.add(this.header);
        JPanel consolePanel = new JPanel();
        consolePanel.setLayout(new BorderLayout());
        this.status = new EditorStatus(this);
        consolePanel.add((Component)this.status, "North");
        this.console = new EditorConsole(this.base);
        this.console.setName("console");
        this.console.setBorder(null);
        consolePanel.add((Component)this.console, "Center");
        this.lineStatus = new EditorLineStatus();
        consolePanel.add((Component)this.lineStatus, "South");
        this.codePanel = new JPanel(new BorderLayout());
        this.upper.add(this.codePanel);
        this.splitPane = new JSplitPane(0, this.upper, consolePanel);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setBorder(null);
        Keys.killBinding(this.splitPane, Keys.ctrl(9));
        Keys.killBinding(this.splitPane, Keys.ctrlShift(9));
        this.splitPane.setDividerSize(Theme.scale(this.splitPane.getDividerSize()));
        this.splitPane.setMinimumSize(Theme.scale(new Dimension(600, 100)));
        box.add(this.splitPane);
        pane.add(box);
        pane.setTransferHandler(new FileDropHandler());
        this.setMinimumSize(Theme.scale(new Dimension(PreferencesData.getInteger((String)"editor.window.width.min"), PreferencesData.getInteger((String)"editor.window.height.min"))));
        this.applyPreferences();
        this.pack();
        this.setPlacement(storedLocation, defaultLocation);
        boolean loaded = this.handleOpenInternal(file);
        if (!loaded) {
            this.sketchController = null;
        }
        EditorConsole.setCurrentEditorConsole(this.console);
    }

    private void setPlacement(int[] storedLocation, int[] defaultLocation) {
        if (storedLocation.length > 5 && storedLocation[5] != 0) {
            this.setExtendedState(storedLocation[5]);
            this.setPlacement(defaultLocation);
        } else {
            this.setPlacement(storedLocation);
        }
    }

    private void setPlacement(int[] location) {
        this.setBounds(location[0], location[1], location[2], location[3]);
        if (location[4] != 0) {
            this.splitPane.setDividerLocation(location[4]);
        }
    }

    protected int[] getPlacement() {
        int[] location = new int[6];
        Rectangle bounds = this.getBounds();
        location[0] = bounds.x;
        location[1] = bounds.y;
        location[2] = bounds.width;
        location[3] = bounds.height;
        location[4] = this.splitPane.getDividerLocation();
        location[5] = this.getExtendedState() & 6;
        return location;
    }

    public void applyPreferences() {
        boolean external = PreferencesData.getBoolean((String)"editor.external");
        this.saveMenuItem.setEnabled(!external);
        this.saveAsMenuItem.setEnabled(!external);
        for (EditorTab tab : this.tabs) {
            tab.applyPreferences();
        }
        this.console.applyPreferences();
        if (serialMonitor != null) {
            serialMonitor.applyPreferences();
        }
    }

    private void buildMenuBar() {
        JMenuBar menubar = new JMenuBar();
        final JMenu fileMenu = this.buildFileMenu();
        fileMenu.addMenuListener(new StubMenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                List<Component> components = Arrays.asList(fileMenu.getMenuComponents());
                if (!components.contains(sketchbookMenu)) {
                    fileMenu.insert(sketchbookMenu, 3);
                }
                if (!components.contains(examplesMenu)) {
                    fileMenu.insert(examplesMenu, 4);
                }
                fileMenu.revalidate();
                Editor.this.validate();
            }
        });
        menubar.add(fileMenu);
        menubar.add(this.buildEditMenu());
        final JMenu sketchMenu = new JMenu(I18n.tr((String)"Sketch"));
        sketchMenu.setMnemonic(83);
        sketchMenu.addMenuListener(new StubMenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                Editor.this.buildSketchMenu(sketchMenu);
                sketchMenu.revalidate();
                Editor.this.validate();
            }
        });
        this.buildSketchMenu(sketchMenu);
        menubar.add(sketchMenu);
        final JMenu toolsMenu = this.buildToolsMenu();
        toolsMenu.addMenuListener(new StubMenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                List<Component> components = Arrays.asList(toolsMenu.getMenuComponents());
                int offset = 0;
                for (JMenu menu : Editor.this.base.getBoardsCustomMenus()) {
                    if (components.contains(menu)) continue;
                    toolsMenu.insert(menu, Editor.this.numTools + offset);
                    ++offset;
                }
                if (!components.contains(portMenu)) {
                    toolsMenu.insert(portMenu, Editor.this.numTools + offset);
                }
                Editor.this.programmersMenu.removeAll();
                Editor.this.base.getProgrammerMenus().forEach(Editor.this.programmersMenu::add);
                toolsMenu.revalidate();
                Editor.this.validate();
            }
        });
        menubar.add(toolsMenu);
        menubar.add(this.buildHelpMenu());
        this.setJMenuBar(menubar);
    }

    private JMenu buildFileMenu() {
        this.fileMenu = new JMenu(I18n.tr((String)"File"));
        this.fileMenu.setMnemonic(70);
        JMenuItem item = Editor.newJMenuItem(I18n.tr((String)"New"), 78);
        item.addActionListener(event -> {
            try {
                this.base.handleNew();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        });
        this.fileMenu.add(item);
        item = Editor.newJMenuItem(I18n.tr((String)"Open..."), 79);
        item.addActionListener(event -> {
            try {
                this.base.handleOpenPrompt();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        });
        this.fileMenu.add(item);
        this.base.rebuildRecentSketchesMenuItems();
        this.recentSketchesMenu = new JMenu(I18n.tr((String)"Open Recent"));
        SwingUtilities.invokeLater(() -> this.rebuildRecentSketchesMenu());
        this.fileMenu.add(this.recentSketchesMenu);
        if (sketchbookMenu == null) {
            sketchbookMenu = new JMenu(I18n.tr((String)"Sketchbook"));
            MenuScroller.setScrollerFor(sketchbookMenu);
            this.base.rebuildSketchbookMenu(sketchbookMenu);
        }
        this.fileMenu.add(sketchbookMenu);
        if (examplesMenu == null) {
            examplesMenu = new JMenu(I18n.tr((String)"Examples"));
            MenuScroller.setScrollerFor(examplesMenu);
            this.base.rebuildExamplesMenu(examplesMenu);
        }
        this.fileMenu.add(examplesMenu);
        item = Editor.newJMenuItem(I18n.tr((String)"Close"), 87);
        item.addActionListener(event -> this.base.handleClose(this));
        this.fileMenu.add(item);
        this.saveMenuItem = Editor.newJMenuItem(I18n.tr((String)"Save"), 83);
        this.saveMenuItem.addActionListener(event -> this.handleSave(false));
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem = Editor.newJMenuItemShift(I18n.tr((String)"Save As..."), 83);
        this.saveAsMenuItem.addActionListener(event -> this.handleSaveAs());
        this.fileMenu.add(this.saveAsMenuItem);
        this.fileMenu.addSeparator();
        item = Editor.newJMenuItemShift(I18n.tr((String)"Page Setup"), 80);
        item.addActionListener(event -> this.handlePageSetup());
        this.fileMenu.add(item);
        item = Editor.newJMenuItem(I18n.tr((String)"Print"), 80);
        item.addActionListener(event -> this.handlePrint());
        this.fileMenu.add(item);
        if (!OSUtils.hasMacOSStyleMenus()) {
            this.fileMenu.addSeparator();
            item = Editor.newJMenuItem(I18n.tr((String)"Preferences"), 44);
            item.addActionListener(event -> this.base.handlePrefs());
            this.fileMenu.add(item);
            this.fileMenu.addSeparator();
            item = Editor.newJMenuItem(I18n.tr((String)"Quit"), 81);
            item.addActionListener(event -> this.base.handleQuit());
            this.fileMenu.add(item);
        }
        return this.fileMenu;
    }

    public void rebuildRecentSketchesMenu() {
        this.recentSketchesMenu.removeAll();
        for (JMenuItem recentSketchMenuItem : this.base.getRecentSketchesMenuItems()) {
            this.recentSketchesMenu.add(recentSketchMenuItem);
        }
    }

    private void buildSketchMenu(JMenu sketchMenu) {
        sketchMenu.removeAll();
        JMenuItem item = Editor.newJMenuItem(I18n.tr((String)"Verify/Compile"), 82);
        item.addActionListener(event -> this.handleRun(false, this.presentHandler, this.runHandler));
        sketchMenu.add(item);
        item = Editor.newJMenuItem(I18n.tr((String)"Upload"), 85);
        item.addActionListener(event -> this.handleExport(false));
        sketchMenu.add(item);
        item = Editor.newJMenuItemShift(I18n.tr((String)"Upload Using Programmer"), 85);
        item.addActionListener(event -> this.handleExport(true));
        sketchMenu.add(item);
        item = Editor.newJMenuItemAlt(I18n.tr((String)"Export compiled Binary"), 83);
        item.addActionListener(event -> {
            if (!new CanExportInSketchFolder().test(this.sketchController)) {
                System.out.println(I18n.tr((String)"Export canceled, changes must first be saved."));
                return;
            }
            this.handleRun(false, new CanExportInSketchFolder(), this.presentAndSaveHandler, this.runAndSaveHandler);
        });
        sketchMenu.add(item);
        sketchMenu.addSeparator();
        item = Editor.newJMenuItem(I18n.tr((String)"Show Sketch Folder"), 75);
        item.addActionListener(event -> Base.openFolder(this.sketch.getFolder()));
        sketchMenu.add(item);
        item.setEnabled(Base.openFolderAvailable());
        if (importMenu == null) {
            importMenu = new JMenu(I18n.tr((String)"Include Library"));
            MenuScroller.setScrollerFor(importMenu);
            this.base.rebuildImportMenu(importMenu);
        }
        sketchMenu.add(importMenu);
        item = new JMenuItem(I18n.tr((String)"Add File..."));
        item.addActionListener(event -> this.sketchController.handleAddFile());
        sketchMenu.add(item);
    }

    private JMenu buildToolsMenu() {
        this.toolsMenu = new JMenu(I18n.tr((String)"Tools"));
        this.toolsMenu.setMnemonic(84);
        this.addInternalTools(this.toolsMenu);
        JMenuItem item = Editor.newJMenuItemShift(I18n.tr((String)"Manage Libraries..."), 73);
        item.addActionListener(e -> this.base.openLibraryManager("", ""));
        this.toolsMenu.add(item);
        item = Editor.newJMenuItemShift(I18n.tr((String)"Serial Monitor"), 77);
        item.addActionListener(e -> this.handleSerial());
        this.toolsMenu.add(item);
        item = Editor.newJMenuItemShift(I18n.tr((String)"Serial Plotter"), 76);
        item.addActionListener(e -> this.handlePlotter());
        this.toolsMenu.add(item);
        this.addTools(this.toolsMenu, BaseNoGui.getToolsFolder());
        File sketchbookTools = new File(BaseNoGui.getSketchbookFolder(), "tools");
        this.addTools(this.toolsMenu, sketchbookTools);
        this.toolsMenu.addSeparator();
        this.numTools = this.toolsMenu.getItemCount();
        this.base.getBoardsCustomMenus().stream().forEach(this.toolsMenu::add);
        if (portMenu == null) {
            portMenu = new JMenu(I18n.tr((String)"Port"));
        }
        this.populatePortMenu();
        this.toolsMenu.add(portMenu);
        MenuScroller.setScrollerFor(portMenu);
        item = new JMenuItem(I18n.tr((String)"Get Board Info"));
        item.addActionListener(e -> this.handleBoardInfo());
        this.toolsMenu.add(item);
        this.toolsMenu.addSeparator();
        this.base.rebuildProgrammerMenu();
        this.programmersMenu = new JMenu(I18n.tr((String)"Programmer"));
        MenuScroller.setScrollerFor(this.programmersMenu);
        this.base.getProgrammerMenus().stream().forEach(this.programmersMenu::add);
        this.toolsMenu.add(this.programmersMenu);
        item = new JMenuItem(I18n.tr((String)"Burn Bootloader"));
        item.addActionListener(e -> this.handleBurnBootloader());
        this.toolsMenu.add(item);
        this.toolsMenu.addMenuListener(new StubMenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                Editor.this.populatePortMenu();
                for (Component c : Editor.this.toolsMenu.getMenuComponents()) {
                    String newname;
                    JMenuItem item;
                    JMenu menu;
                    String name;
                    if (!(c instanceof JMenu) || !c.isVisible() || (name = (menu = (JMenu)c).getText()) == null) continue;
                    String basename = name;
                    int index = name.indexOf(58);
                    if (index > 0) {
                        basename = name.substring(0, index);
                    }
                    String sel = null;
                    int count = menu.getItemCount();
                    for (int i = 0; !(i >= count || (item = menu.getItem(i)) != null && item.isSelected() && (sel = item.getText()) != null); ++i) {
                    }
                    if (sel == null) {
                        if (name.equals(basename)) continue;
                        menu.setText(basename);
                        continue;
                    }
                    if (sel.length() > 50) {
                        sel = sel.substring(0, 50) + "...";
                    }
                    if (name.equals(newname = basename + ": \"" + sel + "\"")) continue;
                    menu.setText(newname);
                }
            }
        });
        return this.toolsMenu;
    }

    private void addTools(JMenu menu, File sourceFolder) {
        if (sourceFolder == null) {
            return;
        }
        HashMap<String, JMenuItem> toolItems = new HashMap<String, JMenuItem>();
        File[] folders = sourceFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File folder) {
                if (folder.isDirectory()) {
                    File subfolder = new File(folder, "tool");
                    return subfolder.exists();
                }
                return false;
            }
        });
        if (folders == null || folders.length == 0) {
            return;
        }
        for (File folder : folders) {
            File toolDirectory = new File(folder, "tool");
            try {
                File[] archives = toolDirectory.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".jar") || name.toLowerCase().endsWith(".zip");
                    }
                });
                URL[] urlList = new URL[archives.length];
                for (int j = 0; j < urlList.length; ++j) {
                    urlList[j] = archives[j].toURI().toURL();
                }
                URLClassLoader loader = new URLClassLoader(urlList);
                String className = null;
                for (File archive : archives) {
                    className = this.findClassInZipFile(folder.getName(), archive);
                    if (className != null) break;
                }
                if (className == null) continue;
                Class<?> toolClass = Class.forName(className, true, loader);
                Tool tool = (Tool)toolClass.newInstance();
                tool.init(this);
                String title = tool.getMenuTitle();
                JMenuItem item = new JMenuItem(title);
                item.addActionListener(event -> SwingUtilities.invokeLater(tool));
                toolItems.put(title, item);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList toolList = new ArrayList(toolItems.keySet());
        if (toolList.size() == 0) {
            return;
        }
        menu.addSeparator();
        Collections.sort(toolList);
        for (String title : toolList) {
            menu.add((JMenuItem)toolItems.get(title));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findClassInZipFile(String base, File file) {
        String classFileName = "/" + base + ".class";
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (true) {
                if (entries.hasMoreElements()) {
                    String name;
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !(name = entry.getName()).endsWith(classFileName)) continue;
                    String string = name.substring(0, name.length() - 6).replace('/', '.');
                    return string;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public void updateKeywords(PdeKeywords keywords) {
        for (EditorTab tab : this.tabs) {
            tab.updateKeywords(keywords);
        }
    }

    JMenuItem createToolMenuItem(String className) {
        try {
            Tool tool = this.getOrCreateToolInstance(className);
            JMenuItem item = new JMenuItem(tool.getMenuTitle());
            tool.init(this);
            item.addActionListener(event -> SwingUtilities.invokeLater(tool));
            return item;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Tool getOrCreateToolInstance(String className) {
        Tool internalTool = this.internalToolCache.get(className);
        if (internalTool == null) {
            try {
                Class<?> toolClass = Class.forName(className);
                internalTool = (Tool)toolClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            this.internalToolCache.put(className, internalTool);
        }
        return internalTool;
    }

    private void addInternalTools(JMenu menu) {
        JMenuItem item = this.createToolMenuItem("cc.arduino.packages.formatter.AStyle");
        if (item == null) {
            throw new NullPointerException("Tool cc.arduino.packages.formatter.AStyle unavailable");
        }
        item.setName("menuToolsAutoFormat");
        int modifiers = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        item.setAccelerator(KeyStroke.getKeyStroke(84, modifiers));
        menu.add(item);
        menu.add(this.createToolMenuItem("processing.app.tools.Archiver"));
        menu.add(this.createToolMenuItem("processing.app.tools.FixEncoding"));
    }

    private void selectSerialPort(String name) {
        if (portMenu == null) {
            System.out.println(I18n.tr((String)"serialMenu is null"));
            return;
        }
        if (name == null) {
            System.out.println(I18n.tr((String)"name is null"));
            return;
        }
        JCheckBoxMenuItem selection = null;
        for (int i = 0; i < portMenu.getItemCount(); ++i) {
            JMenuItem menuItem = portMenu.getItem(i);
            if (!(menuItem instanceof JCheckBoxMenuItem)) continue;
            JCheckBoxMenuItem checkBoxMenuItem = (JCheckBoxMenuItem)menuItem;
            checkBoxMenuItem.setState(false);
            if (!name.equals(checkBoxMenuItem.getText())) continue;
            selection = checkBoxMenuItem;
        }
        if (selection != null) {
            selection.setState(true);
        }
        BaseNoGui.selectSerialPort((String)name);
        try {
            boolean reopenMonitor;
            boolean bl = reopenMonitor = serialMonitor != null && serialMonitor.isVisible() || serialPlotter != null && serialPlotter.isVisible();
            if (serialMonitor != null) {
                serialMonitor.close();
            }
            if (serialPlotter != null) {
                serialPlotter.close();
            }
            if (reopenMonitor) {
                this.handleSerial();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.onBoardOrPortChange();
        this.base.onBoardOrPortChange();
    }

    private void populatePortMenu() {
        List<String> PROTOCOLS_ORDER = Arrays.asList("serial", "network");
        List<String> PROTOCOLS_LABELS = Arrays.asList(I18n.tr((String)"Serial ports"), I18n.tr((String)"Network ports"));
        portMenu.removeAll();
        String selectedPort = PreferencesData.get((String)"serial.port");
        List ports = Base.getDiscoveryManager().discovery();
        ports = this.platform.filterPorts(ports, PreferencesData.getBoolean((String)"serial.ports.showall"));
        ports.stream().filter(port -> port.getProtocolLabel() == null || port.getProtocolLabel().isEmpty()).forEach(port -> {
            int labelIdx = PROTOCOLS_ORDER.indexOf(port.getProtocol());
            if (labelIdx != -1) {
                port.setProtocolLabel((String)PROTOCOLS_LABELS.get(labelIdx));
            } else {
                port.setProtocolLabel(port.getProtocol());
            }
        });
        Collections.sort(ports, (port1, port2) -> {
            int prIdx2;
            String pr1 = port1.getProtocol();
            String pr2 = port2.getProtocol();
            int prIdx1 = PROTOCOLS_ORDER.contains(pr1) ? PROTOCOLS_ORDER.indexOf(pr1) : 999;
            int r = prIdx1 - (prIdx2 = PROTOCOLS_ORDER.contains(pr2) ? PROTOCOLS_ORDER.indexOf(pr2) : 999);
            if (r != 0) {
                return r;
            }
            r = port1.getProtocolLabel().compareTo(port2.getProtocolLabel());
            if (r != 0) {
                return r;
            }
            return port1.getAddress().compareTo(port2.getAddress());
        });
        String lastProtocol = "";
        String lastProtocolLabel = "";
        for (BoardPort port3 : ports) {
            if (!port3.getProtocol().equals(lastProtocol) || !port3.getProtocolLabel().equals(lastProtocolLabel)) {
                if (!lastProtocol.isEmpty()) {
                    portMenu.addSeparator();
                }
                lastProtocol = port3.getProtocol();
                lastProtocolLabel = port3.getProtocolLabel();
                JMenuItem item = new JMenuItem(I18n.tr((String)lastProtocolLabel));
                item.setEnabled(false);
                portMenu.add(item);
            }
            String address = port3.getAddress();
            BoardPortJCheckBoxMenuItem item = new BoardPortJCheckBoxMenuItem(port3);
            item.setSelected(address.equals(selectedPort));
            portMenu.add(item);
        }
        portMenu.setEnabled(portMenu.getMenuComponentCount() > 0);
    }

    private JMenu buildHelpMenu() {
        JMenu menu = new JMenu(I18n.tr((String)"Help"));
        menu.setMnemonic(72);
        JMenuItem item = new JMenuItem(I18n.tr((String)"Getting Started"));
        item.addActionListener(event -> Base.showArduinoGettingStarted());
        menu.add(item);
        item = new JMenuItem(I18n.tr((String)"Environment"));
        item.addActionListener(event -> Base.showEnvironment());
        menu.add(item);
        item = new JMenuItem(I18n.tr((String)"Troubleshooting"));
        item.addActionListener(event -> Base.showTroubleshooting());
        menu.add(item);
        item = new JMenuItem(I18n.tr((String)"Reference"));
        item.addActionListener(event -> Base.showReference());
        menu.add(item);
        menu.addSeparator();
        item = Editor.newJMenuItemShift(I18n.tr((String)"Find in Reference"), 70);
        item.addActionListener(event -> this.handleFindReference(event));
        menu.add(item);
        item = new JMenuItem(I18n.tr((String)"Frequently Asked Questions"));
        item.addActionListener(event -> Base.showFAQ());
        menu.add(item);
        item = new JMenuItem(I18n.tr((String)"Visit Arduino.cc"));
        item.addActionListener(event -> Base.openURL(I18n.tr((String)"http://www.arduino.cc/")));
        menu.add(item);
        if (!OSUtils.hasMacOSStyleMenus()) {
            menu.addSeparator();
            item = new JMenuItem(I18n.tr((String)"About Arduino"));
            item.addActionListener(event -> this.base.handleAbout());
            menu.add(item);
        }
        return menu;
    }

    private JMenu buildEditMenu() {
        JMenu menu = new JMenu(I18n.tr((String)"Edit"));
        menu.setName("menuEdit");
        menu.setMnemonic(69);
        this.undoItem = Editor.newJMenuItem(I18n.tr((String)"Undo"), 90);
        this.undoItem.setName("menuEditUndo");
        this.undoItem.addActionListener(event -> this.getCurrentTab().handleUndo());
        menu.add(this.undoItem);
        this.redoItem = !OSUtils.isMacOS() ? Editor.newJMenuItem(I18n.tr((String)"Redo"), 89) : Editor.newJMenuItemShift(I18n.tr((String)"Redo"), 90);
        this.redoItem.setName("menuEditRedo");
        this.redoItem.addActionListener(event -> this.getCurrentTab().handleRedo());
        menu.add(this.redoItem);
        menu.addSeparator();
        final JMenuItem cutItem = Editor.newJMenuItem(I18n.tr((String)"Cut"), 88);
        cutItem.addActionListener(event -> this.getCurrentTab().handleCut());
        menu.add(cutItem);
        final JMenuItem copyItem = Editor.newJMenuItem(I18n.tr((String)"Copy"), 67);
        copyItem.addActionListener(event -> this.getCurrentTab().getTextArea().copy());
        menu.add(copyItem);
        JMenuItem copyForumItem = Editor.newJMenuItemShift(I18n.tr((String)"Copy for Forum"), 67);
        copyForumItem.addActionListener(event -> this.getCurrentTab().handleDiscourseCopy());
        menu.add(copyForumItem);
        JMenuItem copyHTMLItem = Editor.newJMenuItemAlt(I18n.tr((String)"Copy as HTML"), 67);
        copyHTMLItem.addActionListener(event -> this.getCurrentTab().handleHTMLCopy());
        menu.add(copyHTMLItem);
        JMenuItem pasteItem = Editor.newJMenuItem(I18n.tr((String)"Paste"), 86);
        pasteItem.addActionListener(event -> this.getCurrentTab().handlePaste());
        menu.add(pasteItem);
        JMenuItem selectAllItem = Editor.newJMenuItem(I18n.tr((String)"Select All"), 65);
        selectAllItem.addActionListener(event -> this.getCurrentTab().handleSelectAll());
        menu.add(selectAllItem);
        JMenuItem gotoLine = Editor.newJMenuItem(I18n.tr((String)"Go to line..."), 76);
        gotoLine.addActionListener(event -> {
            GoToLineNumber goToLineNumber = new GoToLineNumber(this);
            goToLineNumber.setLocationRelativeTo(this);
            goToLineNumber.setVisible(true);
        });
        menu.add(gotoLine);
        menu.addSeparator();
        JMenuItem commentItem = Editor.newJMenuItem(I18n.tr((String)"Comment/Uncomment"), PreferencesData.get((String)"editor.keys.shortcut_comment", (String)"/").charAt(0));
        commentItem.addActionListener(event -> this.getCurrentTab().handleCommentUncomment());
        menu.add(commentItem);
        JMenuItem increaseIndentItem = new JMenuItem(I18n.tr((String)"Increase Indent"));
        increaseIndentItem.setAccelerator(KeyStroke.getKeyStroke(9, 0));
        increaseIndentItem.addActionListener(event -> this.getCurrentTab().handleIndentOutdent(true));
        menu.add(increaseIndentItem);
        JMenuItem decreseIndentItem = new JMenuItem(I18n.tr((String)"Decrease Indent"));
        decreseIndentItem.setAccelerator(KeyStroke.getKeyStroke(9, 1));
        decreseIndentItem.setName("menuDecreaseIndent");
        decreseIndentItem.addActionListener(event -> this.getCurrentTab().handleIndentOutdent(false));
        menu.add(decreseIndentItem);
        menu.addSeparator();
        JMenuItem increaseFontSizeItem = Editor.newJMenuItem(I18n.tr((String)"Increase Font Size"), 521);
        increaseFontSizeItem.addActionListener(event -> this.base.handleFontSizeChange(1));
        menu.add(increaseFontSizeItem);
        KeyStroke ctrlShiftEq = KeyStroke.getKeyStroke(61, SHORTCUT_KEY_MASK | 1);
        menu.getInputMap(2).put(ctrlShiftEq, "IncreaseFontSize");
        KeyStroke ctrlEq = KeyStroke.getKeyStroke(61, SHORTCUT_KEY_MASK);
        menu.getInputMap(2).put(ctrlEq, "IncreaseFontSize");
        menu.getActionMap().put("IncreaseFontSize", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor.this.base.handleFontSizeChange(1);
            }
        });
        JMenuItem decreaseFontSizeItem = Editor.newJMenuItem(I18n.tr((String)"Decrease Font Size"), 45);
        decreaseFontSizeItem.addActionListener(event -> this.base.handleFontSizeChange(-1));
        menu.add(decreaseFontSizeItem);
        menu.addSeparator();
        JMenuItem findItem = Editor.newJMenuItem(I18n.tr((String)"Find..."), 70);
        findItem.addActionListener(event -> {
            if (this.find == null) {
                this.find = new FindReplace(this, Base.FIND_DIALOG_STATE);
            }
            if (!OSUtils.isMacOS()) {
                this.find.setFindText(this.getCurrentTab().getSelectedText());
            }
            this.find.setLocationRelativeTo(this);
            this.find.setVisible(true);
        });
        menu.add(findItem);
        JMenuItem findNextItem = Editor.newJMenuItem(I18n.tr((String)"Find Next"), 71);
        findNextItem.addActionListener(event -> {
            if (this.find != null) {
                this.find.findNext();
            }
        });
        menu.add(findNextItem);
        JMenuItem findPreviousItem = Editor.newJMenuItemShift(I18n.tr((String)"Find Previous"), 71);
        findPreviousItem.addActionListener(event -> {
            if (this.find != null) {
                this.find.findPrevious();
            }
        });
        menu.add(findPreviousItem);
        if (OSUtils.isMacOS()) {
            JMenuItem useSelectionForFindItem = Editor.newJMenuItem(I18n.tr((String)"Use Selection For Find"), 69);
            useSelectionForFindItem.addActionListener(event -> {
                if (this.find == null) {
                    this.find = new FindReplace(this, Base.FIND_DIALOG_STATE);
                }
                this.find.setFindText(this.getCurrentTab().getSelectedText());
            });
            menu.add(useSelectionForFindItem);
        }
        menu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                boolean enabled = Editor.this.getCurrentTab().getSelectedText() != null;
                cutItem.setEnabled(enabled);
                copyItem.setEnabled(enabled);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        return menu;
    }

    public static JMenuItem newJMenuItem(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, SHORTCUT_KEY_MASK));
        return menuItem;
    }

    public static JMenuItem newJMenuItemShift(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, SHORTCUT_KEY_MASK | 1));
        return menuItem;
    }

    private static JMenuItem newJMenuItemAlt(String title, int what) {
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(what, SHORTCUT_ALT_KEY_MASK));
        return menuItem;
    }

    protected void updateUndoRedoState() {
        SketchTextArea textArea = this.getCurrentTab().getTextArea();
        this.undoItem.setEnabled(textArea.canUndo());
        this.redoItem.setEnabled(textArea.canRedo());
    }

    private void resetHandlers() {
        this.runHandler = new BuildHandler();
        this.presentHandler = new BuildHandler(true);
        this.runAndSaveHandler = new BuildHandler(false, true);
        this.presentAndSaveHandler = new BuildHandler(true, true);
        this.uploadHandler = new UploadHandler();
        this.uploadHandler.setUsingProgrammer(false);
        this.uploadUsingProgrammerHandler = new UploadHandler();
        this.uploadUsingProgrammerHandler.setUsingProgrammer(true);
        this.timeoutUploadHandler = new TimeoutUploadHandler();
    }

    public SketchController getSketchController() {
        return this.sketchController;
    }

    public Sketch getSketch() {
        return this.sketch;
    }

    public EditorTab getCurrentTab() {
        return this.tabs.get(this.currentTabIndex);
    }

    public int getCurrentTabIndex() {
        return this.currentTabIndex;
    }

    public List<EditorTab> getTabs() {
        return Collections.unmodifiableList(this.tabs);
    }

    public void selectTab(int index) {
        this.currentTabIndex = index;
        this.updateUndoRedoState();
        this.updateTitle();
        this.header.rebuild();
        this.getCurrentTab().activated();
        SwingUtilities.invokeLater(() -> {
            this.codePanel.removeAll();
            this.codePanel.add((Component)this.tabs.get(index), "Center");
            this.tabs.get(index).requestFocusInWindow();
            this.codePanel.revalidate();
            this.codePanel.repaint();
        });
    }

    public void selectNextTab() {
        this.selectTab((this.currentTabIndex + 1) % this.tabs.size());
    }

    public void selectPrevTab() {
        this.selectTab((this.currentTabIndex - 1 + this.tabs.size()) % this.tabs.size());
    }

    public EditorTab findTab(SketchFile file) {
        return this.tabs.get(this.findTabIndex(file));
    }

    public int findTabIndex(SketchFile file) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (this.tabs.get(i).getSketchFile() != file) continue;
            return i;
        }
        return -1;
    }

    public int findTabIndex(File file) {
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (!this.tabs.get(i).getSketchFile().getFile().equals(file)) continue;
            return i;
        }
        return -1;
    }

    public void createTabs() {
        this.tabs.clear();
        this.currentTabIndex = -1;
        this.tabs.ensureCapacity(this.sketch.getCodeCount());
        for (SketchFile file : this.sketch.getFiles()) {
            try {
                this.addTab(file, null);
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
        this.selectTab(0);
    }

    public void reorderTabs() {
        Collections.sort(this.tabs, (x, y) -> Sketch.CODE_DOCS_COMPARATOR.compare(x.getSketchFile(), y.getSketchFile()));
    }

    protected void addTab(SketchFile file, String contents) throws IOException {
        EditorTab tab = new EditorTab(this, file, contents);
        tab.getTextArea().getDocument().addDocumentListener(new DocumentTextChangeListener(() -> this.updateUndoRedoState()));
        this.tabs.add(tab);
        this.reorderTabs();
    }

    protected void removeTab(SketchFile file) throws IOException {
        int index = this.findTabIndex(file);
        this.tabs.remove(index);
    }

    void handleFindReference(ActionEvent e) {
        String text = this.getCurrentTab().getCurrentKeyword();
        String referenceFile = this.base.getPdeKeywords().getReference(text);
        if (referenceFile == null) {
            this.statusNotice(I18n.format((String)I18n.tr((String)"No reference available for \"{0}\""), (Object[])new Object[]{text}));
        } else if (referenceFile.startsWith("Serial_")) {
            Base.showReference("Serial/" + referenceFile.substring("Serial_".length()));
        } else {
            Base.showReference("Reference/" + referenceFile);
        }
    }

    public void handleRun(boolean verbose, Runnable verboseHandler, Runnable nonVerboseHandler) {
        this.handleRun(verbose, new ShouldSaveIfModified(), verboseHandler, nonVerboseHandler);
    }

    private void handleRun(boolean verbose, Predicate<SketchController> shouldSavePredicate, Runnable verboseHandler, Runnable nonVerboseHandler) {
        if (shouldSavePredicate.test(this.sketchController)) {
            this.handleSave(true);
        }
        this.toolbar.activateRun();
        this.status.progress(I18n.tr((String)"Compiling sketch..."));
        for (int i = 0; i < 10; ++i) {
            System.out.println();
        }
        if (PreferencesData.getBoolean((String)"console.auto_clear")) {
            this.console.clear();
        }
        new Thread(verbose ? verboseHandler : nonVerboseHandler).start();
    }

    public void removeAllLineHighlights() {
        for (EditorTab tab : this.tabs) {
            tab.getTextArea().removeAllLineHighlights();
        }
    }

    public void addLineHighlight(int line) throws BadLocationException {
        SketchTextArea textArea = this.getCurrentTab().getTextArea();
        FoldManager foldManager = textArea.getFoldManager();
        if (foldManager.isLineHidden(line)) {
            for (int i = 0; i < foldManager.getFoldCount(); ++i) {
                if (!foldManager.getFold(i).containsLine(line)) continue;
                foldManager.getFold(i).setCollapsed(false);
            }
        }
        textArea.addLineHighlight(line, new Color(1.0f, 0.0f, 0.0f, 0.2f));
        textArea.setCaretPosition(textArea.getLineStartOffset(line));
    }

    private void handleStop() {
        this.toolbar.deactivateRun();
        this.toFront();
    }

    protected boolean checkModified() {
        if (!this.sketch.isModified()) {
            return true;
        }
        this.toFront();
        String prompt = I18n.format((String)I18n.tr((String)"Save changes to \"{0}\"?  "), (Object[])new Object[]{this.sketch.getName()});
        if (!OSUtils.hasMacOSStyleMenus()) {
            int result = JOptionPane.showConfirmDialog(this, prompt, I18n.tr((String)"Close"), 1, 3);
            switch (result) {
                case 0: {
                    return this.handleSave(true);
                }
                case 1: {
                    return true;
                }
                case -1: 
                case 2: {
                    return false;
                }
            }
            throw new IllegalStateException();
        }
        JOptionPane pane = new JOptionPane(I18n.tr((String)"<html> <head> <style type=\"text/css\">b { font: 13pt \"Lucida Grande\" }p { font: 11pt \"Lucida Grande\"; margin-top: 8px }</style> </head><b>Do you want to save changes to this sketch<BR> before closing?</b><p>If you don't save, your changes will be lost."), 3);
        Object[] options = new String[]{I18n.tr((String)"Save"), I18n.tr((String)"Cancel"), I18n.tr((String)"Don't Save")};
        pane.setOptions(options);
        pane.setInitialValue(options[0]);
        JDialog dialog = pane.createDialog(this, null);
        dialog.setVisible(true);
        Object result = pane.getValue();
        if (result == options[0]) {
            return this.handleSave(true);
        }
        return result == options[2];
    }

    protected boolean handleOpenInternal(File sketchFile) {
        String fileName = sketchFile.getName();
        File file = Sketch.checkSketchFile((File)sketchFile);
        if (file == null) {
            if (!fileName.endsWith(".ino") && !fileName.endsWith(".pde")) {
                Base.showWarning(I18n.tr((String)"Bad file selected"), I18n.tr((String)"Arduino can only open its own sketches\nand other files ending in .ino or .pde"), null);
                return false;
            }
            String properParent = fileName.substring(0, fileName.length() - 4);
            Object[] options = new Object[]{I18n.tr((String)"OK"), I18n.tr((String)"Cancel")};
            String prompt = I18n.format((String)I18n.tr((String)"The file \"{0}\" needs to be inside\na sketch folder named \"{1}\".\nCreate this folder, move the file, and continue?"), (Object[])new Object[]{fileName, properParent});
            int result = JOptionPane.showOptionDialog(this, prompt, I18n.tr((String)"Moving"), 0, 3, null, options, options[0]);
            if (result != 0) {
                return false;
            }
            File properFolder = new File(sketchFile.getParent(), properParent);
            if (properFolder.exists()) {
                Base.showWarning(I18n.tr((String)"Error"), I18n.format((String)I18n.tr((String)"A folder named \"{0}\" already exists. Can't open sketch."), (Object[])new Object[]{properParent}), null);
                return false;
            }
            if (!properFolder.mkdirs()) {
                Base.showWarning(I18n.tr((String)"Error"), I18n.tr((String)"Could not create the sketch folder."), null);
                return false;
            }
            File properPdeFile = new File(properFolder, sketchFile.getName());
            try {
                Base.copyFile(sketchFile, properPdeFile);
            }
            catch (IOException e) {
                Base.showWarning(I18n.tr((String)"Error"), I18n.tr((String)"Could not copy to a proper location."), e);
                return false;
            }
            sketchFile.delete();
            file = properPdeFile;
        }
        try {
            this.sketch = new Sketch(file);
        }
        catch (IOException e) {
            Base.showWarning(I18n.tr((String)"Error"), I18n.tr((String)"Could not create the sketch."), e);
            return false;
        }
        this.sketchController = new SketchController(this, this.sketch);
        this.createTabs();
        this.untitled = false;
        return true;
    }

    public void updateTitle() {
        if (this.sketchController == null) {
            return;
        }
        SketchFile current = this.getCurrentTab().getSketchFile();
        String customFormat = PreferencesData.get((String)"editor.custom_title_format");
        if (customFormat != null && !customFormat.trim().isEmpty()) {
            HashMap<String, String> titleMap = new HashMap<String, String>();
            titleMap.put("file", current.getFileName());
            String path = this.sketch.getFolder().getAbsolutePath();
            titleMap.put("folder", path);
            titleMap.put("path", path);
            titleMap.put("project", this.sketch.getName());
            titleMap.put("version", BaseNoGui.VERSION_NAME_LONG);
            this.setTitle(StringReplacer.replaceFromMapping((String)customFormat, titleMap));
        } else if (current.isPrimary()) {
            this.setTitle(I18n.format((String)I18n.tr((String)"{0} | Arduino {1}"), (Object[])new Object[]{this.sketch.getName(), BaseNoGui.VERSION_NAME_LONG}));
        } else {
            this.setTitle(I18n.format((String)I18n.tr((String)"{0} - {1} | Arduino {2}"), (Object[])new Object[]{this.sketch.getName(), current.getFileName(), BaseNoGui.VERSION_NAME_LONG}));
        }
    }

    public boolean handleSave(boolean immediately) {
        this.handleStop();
        this.removeAllLineHighlights();
        if (this.untitled) {
            return this.handleSaveAs();
        }
        if (immediately) {
            return this.handleSave2();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Editor.this.handleSave2();
            }
        });
        return true;
    }

    private boolean handleSave2() {
        this.toolbar.activateSave();
        this.statusNotice(I18n.tr((String)"Saving..."));
        boolean saved = false;
        try {
            if (PreferencesData.getBoolean((String)"editor.autoformat_currentfile_before_saving")) {
                Tool formatTool = this.getOrCreateToolInstance("cc.arduino.packages.formatter.AStyle");
                formatTool.run();
            }
            boolean wasReadOnly = this.sketchController.isReadOnly();
            String previousMainFilePath = this.sketch.getMainFilePath();
            saved = this.sketchController.save();
            if (saved) {
                this.statusNotice(I18n.tr((String)"Done Saving."));
                if (wasReadOnly) {
                    this.base.removeRecentSketchPath(previousMainFilePath);
                }
                this.base.storeRecentSketches(this.sketchController);
                this.base.rebuildRecentSketchesMenuItems();
            } else {
                this.statusEmpty();
            }
        }
        catch (Exception e) {
            this.statusError(e);
        }
        this.toolbar.deactivateSave();
        return saved;
    }

    public boolean handleSaveAs() {
        block6: {
            this.handleStop();
            this.toolbar.activateSave();
            this.statusNotice(I18n.tr((String)"Saving..."));
            try {
                if (this.sketchController.saveAs()) {
                    this.base.storeRecentSketches(this.sketchController);
                    this.base.rebuildRecentSketchesMenuItems();
                    this.statusNotice(I18n.tr((String)"Done Saving."));
                    break block6;
                }
                this.statusNotice(I18n.tr((String)"Save Canceled."));
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                this.statusError(e);
            }
            finally {
                this.toolbar.deactivateSave();
                this.updateTitle();
                this.header.rebuild();
            }
        }
        return true;
    }

    private boolean serialPrompt() {
        ArrayList<BoardPortJCheckBoxMenuItem> items = new ArrayList<BoardPortJCheckBoxMenuItem>();
        for (int i = 0; i < portMenu.getItemCount(); ++i) {
            if (!(portMenu.getItem(i) instanceof BoardPortJCheckBoxMenuItem)) continue;
            items.add((BoardPortJCheckBoxMenuItem)portMenu.getItem(i));
        }
        String port = PreferencesData.get((String)"serial.port");
        String title = port == null || port.isEmpty() ? I18n.tr((String)"Serial port not selected.") : I18n.format((String)I18n.tr((String)"Serial port {0} not found."), (Object[])new Object[]{port});
        String question = I18n.tr((String)"Retry the upload with another serial port?");
        BoardPortJCheckBoxMenuItem result = (BoardPortJCheckBoxMenuItem)JOptionPane.showInputDialog(this, title + "\n" + question, title, -1, null, items.toArray(), 0);
        if (result == null) {
            return false;
        }
        result.doClick();
        this.base.onBoardOrPortChange();
        return true;
    }

    public synchronized void handleExport(boolean usingProgrammer) {
        if (PreferencesData.getBoolean((String)"editor.save_on_verify") && this.sketch.isModified() && !this.sketchController.isReadOnly()) {
            this.handleSave(true);
        }
        this.toolbar.activateExport();
        this.console.clear();
        this.status.progress(I18n.tr((String)"Uploading to I/O Board..."));
        avoidMultipleOperations = true;
        new Thread(this.timeoutUploadHandler).start();
        new Thread(usingProgrammer ? this.uploadUsingProgrammerHandler : this.uploadHandler).start();
    }

    public static boolean isUploading() {
        return uploading;
    }

    private void resumeOrCloseSerialMonitor() {
        if (serialMonitor != null) {
            BoardPort boardPort = BaseNoGui.getDiscoveryManager().find(PreferencesData.get((String)"serial.port"));
            long sleptFor = 0L;
            while (boardPort == null && sleptFor < 10000L) {
                try {
                    Thread.sleep(100L);
                    sleptFor += 100L;
                    boardPort = BaseNoGui.getDiscoveryManager().find(PreferencesData.get((String)"serial.port"));
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                if (serialMonitor != null) {
                    serialMonitor.resume(boardPort);
                    if (boardPort == null) {
                        serialMonitor.close();
                        this.handleSerial();
                    } else {
                        serialMonitor.resume(boardPort);
                    }
                }
            }
            catch (Exception e) {
                this.statusError(e);
            }
        }
    }

    private void resumeOrCloseSerialPlotter() {
        if (serialPlotter != null) {
            BoardPort boardPort = BaseNoGui.getDiscoveryManager().find(PreferencesData.get((String)"serial.port"));
            try {
                if (serialPlotter != null) {
                    serialPlotter.resume(boardPort);
                }
                if (boardPort == null) {
                    serialPlotter.close();
                    this.handlePlotter();
                } else {
                    serialPlotter.resume(boardPort);
                }
            }
            catch (Exception e) {
                this.statusError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSerial() {
        BoardPort port;
        if (serialPlotter != null) {
            if (serialPlotter.isClosed()) {
                serialPlotter = null;
            } else {
                this.statusError(I18n.tr((String)"Serial monitor not available while plotter is open"));
                return;
            }
        }
        if (serialMonitor != null) {
            if (serialMonitor.isClosed()) {
                serialMonitor.dispose();
                serialMonitor = null;
            } else {
                try {
                    serialMonitor.toFront();
                    serialMonitor.requestFocus();
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if ((port = Base.getDiscoveryManager().find(PreferencesData.get((String)"serial.port"))) == null) {
            this.statusError(I18n.format((String)I18n.tr((String)"Board at {0} is not available"), (Object[])new Object[]{PreferencesData.get((String)"serial.port")}));
            return;
        }
        serialMonitor = new MonitorFactory().newMonitor(port);
        if (serialMonitor == null) {
            String board = (String)port.getPrefs().get((Object)"board");
            String boardName = BaseNoGui.getPlatform().resolveDeviceByBoardID(BaseNoGui.packages, board);
            this.statusError(I18n.format((String)I18n.tr((String)"Serial monitor is not supported on network ports such as {0} for the {1} in this release"), (Object[])new Object[]{PreferencesData.get((String)"serial.port"), boardName}));
            return;
        }
        this.base.addEditorFontResizeListeners(serialMonitor);
        Base.setIcon(serialMonitor);
        if (uploading || avoidMultipleOperations) {
            try {
                serialMonitor.suspend();
            }
            catch (Exception e) {
                this.statusError(e);
            }
        }
        boolean success = false;
        do {
            if (serialMonitor.requiresAuthorization() && !PreferencesData.has((String)serialMonitor.getAuthorizationKey())) {
                PasswordAuthorizationDialog dialog = new PasswordAuthorizationDialog((Frame)this, I18n.tr((String)"Type board password to access its console"));
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isCancelled()) {
                    this.statusNotice(I18n.tr((String)"Unable to open serial monitor"));
                    return;
                }
                PreferencesData.set((String)serialMonitor.getAuthorizationKey(), (String)dialog.getPassword());
            }
            try {
                if (!avoidMultipleOperations) {
                    serialMonitor.open();
                }
                serialMonitor.setVisible(true);
                success = true;
                this.statusEmpty();
            }
            catch (ConnectException e) {
                this.statusError(I18n.tr((String)"Unable to connect: is the sketch using the bridge?"));
            }
            catch (JSchException e) {
                this.statusError(I18n.tr((String)"Unable to connect: wrong password?"));
            }
            catch (SerialException e) {
                String errorMessage = e.getMessage();
                if (e.getCause() != null && e.getCause() instanceof SerialPortException) {
                    errorMessage = errorMessage + " (" + ((SerialPortException)e.getCause()).getExceptionType() + ")";
                }
                serialMonitor = null;
                this.statusError(errorMessage);
                try {
                    serialMonitor.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                this.statusError(e);
            }
            finally {
                if (serialMonitor != null && serialMonitor.requiresAuthorization() && !success) {
                    PreferencesData.remove((String)serialMonitor.getAuthorizationKey());
                }
            }
        } while (serialMonitor != null && serialMonitor.requiresAuthorization() && !success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePlotter() {
        BoardPort port;
        if (serialMonitor != null) {
            if (serialMonitor.isClosed()) {
                serialMonitor = null;
            } else {
                this.statusError(I18n.tr((String)"Plotter not available while serial monitor is open"));
                return;
            }
        }
        if (serialPlotter != null) {
            if (serialPlotter.isClosed()) {
                serialPlotter.dispose();
                serialPlotter = null;
            } else {
                try {
                    serialPlotter.toFront();
                    serialPlotter.requestFocus();
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if ((port = Base.getDiscoveryManager().find(PreferencesData.get((String)"serial.port"))) == null) {
            this.statusError(I18n.format((String)I18n.tr((String)"Board at {0} is not available"), (Object[])new Object[]{PreferencesData.get((String)"serial.port")}));
            return;
        }
        serialPlotter = new SerialPlotter(port);
        Base.setIcon(serialPlotter);
        if (uploading) {
            try {
                serialPlotter.suspend();
            }
            catch (Exception e) {
                this.statusError(e);
            }
        }
        boolean success = false;
        do {
            if (serialPlotter.requiresAuthorization() && !PreferencesData.has((String)serialPlotter.getAuthorizationKey())) {
                PasswordAuthorizationDialog dialog = new PasswordAuthorizationDialog((Frame)this, I18n.tr((String)"Type board password to access its console"));
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isCancelled()) {
                    this.statusNotice(I18n.tr((String)"Unable to open serial plotter"));
                    return;
                }
                PreferencesData.set((String)serialPlotter.getAuthorizationKey(), (String)dialog.getPassword());
            }
            try {
                serialPlotter.open();
                serialPlotter.setVisible(true);
                success = true;
                this.statusEmpty();
            }
            catch (ConnectException e) {
                this.statusError(I18n.tr((String)"Unable to connect: is the sketch using the bridge?"));
            }
            catch (JSchException e) {
                this.statusError(I18n.tr((String)"Unable to connect: wrong password?"));
            }
            catch (SerialException e) {
                String errorMessage = e.getMessage();
                if (e.getCause() != null && e.getCause() instanceof SerialPortException) {
                    errorMessage = errorMessage + " (" + ((SerialPortException)e.getCause()).getExceptionType() + ")";
                }
                this.statusError(errorMessage);
                serialPlotter = null;
            }
            catch (Exception e) {
                this.statusError(e);
            }
            finally {
                if (serialPlotter != null && serialPlotter.requiresAuthorization() && !success) {
                    PreferencesData.remove((String)serialPlotter.getAuthorizationKey());
                }
            }
        } while (serialPlotter != null && serialPlotter.requiresAuthorization() && !success);
    }

    private void handleBurnBootloader() {
        this.console.clear();
        EditorConsole.setCurrentEditorConsole(this.console);
        this.statusNotice(I18n.tr((String)"Burning bootloader to I/O Board (this may take a minute)..."));
        new Thread(() -> {
            try {
                SerialUploader uploader = new SerialUploader();
                if (uploader.burnBootloader()) {
                    SwingUtilities.invokeLater(() -> this.statusNotice(I18n.tr((String)"Done burning bootloader.")));
                } else {
                    SwingUtilities.invokeLater(() -> this.statusError(I18n.tr((String)"Error while burning bootloader.")));
                }
            }
            catch (SerialNotFoundException e) {
                SwingUtilities.invokeLater(() -> this.statusError(I18n.tr((String)"Error while burning bootloader: please select a serial port.")));
            }
            catch (PreferencesMapException e) {
                SwingUtilities.invokeLater(() -> this.statusError(I18n.format((String)I18n.tr((String)"Error while burning bootloader: missing '{0}' configuration parameter"), (Object[])new Object[]{e.getMessage()})));
            }
            catch (RunnerException e) {
                SwingUtilities.invokeLater(() -> this.statusError(e.getMessage()));
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(() -> this.statusError(I18n.tr((String)"Error while burning bootloader.")));
                e.printStackTrace();
            }
        }).start();
    }

    private void handleBoardInfo() {
        this.console.clear();
        String selectedPort = PreferencesData.get((String)"serial.port");
        List ports = Base.getDiscoveryManager().discovery();
        String label = "";
        String vid = "";
        String pid = "";
        String iserial = "";
        String protocol = "";
        boolean found = false;
        for (BoardPort port : ports) {
            if (!port.getAddress().equals(selectedPort)) continue;
            label = port.getBoardName();
            vid = (String)port.getPrefs().get((Object)"vid");
            pid = (String)port.getPrefs().get((Object)"pid");
            iserial = (String)port.getPrefs().get((Object)"iserial");
            protocol = port.getProtocol();
            found = true;
            break;
        }
        if (!found) {
            this.statusNotice(I18n.tr((String)"Please select a port to obtain board info"));
            return;
        }
        if (protocol.equals("network")) {
            this.statusNotice(I18n.tr((String)"Network port, can't obtain info"));
            return;
        }
        if (vid == null || vid.equals("") || vid.equals("0000")) {
            this.statusNotice(I18n.tr((String)"Native serial port, can't obtain info"));
            return;
        }
        if (iserial == null || iserial.equals("")) {
            iserial = I18n.tr((String)"Upload any sketch to obtain it");
        }
        if (label == null) {
            label = I18n.tr((String)"Unknown board");
        }
        String infos = I18n.format((String)"BN: {0}\nVID: {1}\nPID: {2}\nSN: {3}", (Object[])new Object[]{label, vid, pid, iserial});
        JTextArea textArea = new JTextArea(infos);
        JOptionPane.showMessageDialog(this, textArea, I18n.tr((String)"Board Info"), -1);
    }

    private void handlePageSetup() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.pageFormat == null) {
            this.pageFormat = printerJob.defaultPage();
        }
        this.pageFormat = printerJob.pageDialog(this.pageFormat);
    }

    private void handlePrint() {
        this.statusNotice(I18n.tr((String)"Printing..."));
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.pageFormat != null) {
            printerJob.setPrintable((Printable)((Object)this.getCurrentTab().getTextArea()), this.pageFormat);
        } else {
            printerJob.setPrintable((Printable)((Object)this.getCurrentTab().getTextArea()));
        }
        printerJob.setJobName(this.getCurrentTab().getSketchFile().getPrettyName());
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
                this.statusNotice(I18n.tr((String)"Done printing."));
            }
            catch (PrinterException pe) {
                this.statusError(I18n.tr((String)"Error while printing."));
                pe.printStackTrace();
            }
        } else {
            this.statusNotice(I18n.tr((String)"Printing canceled."));
        }
    }

    @Override
    public void statusError(String what) {
        System.err.println(what);
        this.status.error(what);
        this.toolbar.deactivateRun();
    }

    @Override
    public void statusError(Exception e) {
        String mess;
        e.printStackTrace();
        if (e instanceof RunnerException) {
            RunnerException re = (RunnerException)((Object)e);
            if (re.hasCodeFile()) {
                this.selectTab(this.findTabIndex(re.getCodeFile()));
            }
            if (re.hasCodeLine()) {
                int line = re.getCodeLine();
                if (line >= this.getCurrentTab().getTextArea().getLineCount()) {
                    line = this.getCurrentTab().getTextArea().getLineCount() - 1;
                    if (this.getCurrentTab().getLineText(line).length() == 0) {
                        --line;
                    }
                }
                if (line < 0 || line >= this.getCurrentTab().getTextArea().getLineCount()) {
                    System.err.println(I18n.format((String)I18n.tr((String)"Bad error line: {0}"), (Object[])new Object[]{line}));
                } else {
                    try {
                        this.addLineHighlight(line);
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        if ((mess = e.getMessage()) != null) {
            String rxString;
            String javaLang = "java.lang.";
            if (mess.indexOf(javaLang) == 0) {
                mess = mess.substring(javaLang.length());
            }
            if (mess.indexOf(rxString = "RuntimeException: ") == 0) {
                mess = mess.substring(rxString.length());
            }
            this.statusError(mess);
        }
    }

    @Override
    public void statusNotice(String msg) {
        this.status.notice(msg);
    }

    private void statusEmpty() {
        this.statusNotice(EMPTY);
    }

    protected void onBoardOrPortChange() {
        TargetBoard board = BaseNoGui.getTargetBoard();
        if (board != null) {
            this.lineStatus.setBoardName(board.getName());
        } else {
            this.lineStatus.setBoardName("-");
        }
        this.lineStatus.setPort(PreferencesData.get((String)"serial.port"));
        this.lineStatus.repaint();
    }

    public void addCompilerProgressListener(CompilerProgressListener listener) {
        this.status.addCompilerProgressListener(listener);
    }

    class TimeoutUploadHandler
    implements Runnable {
        TimeoutUploadHandler() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(10000L);
                if (uploading) {
                    avoidMultipleOperations = false;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class UploadHandler
    implements Runnable {
        boolean usingProgrammer = false;

        UploadHandler() {
        }

        public void setUsingProgrammer(boolean usingProgrammer) {
            this.usingProgrammer = usingProgrammer;
        }

        @Override
        public void run() {
            try {
                boolean success;
                uploading = true;
                Editor.this.removeAllLineHighlights();
                if (serialMonitor != null) {
                    serialMonitor.suspend();
                }
                if (serialPlotter != null) {
                    serialPlotter.suspend();
                }
                if (success = Editor.this.sketchController.exportApplet(this.usingProgrammer)) {
                    Editor.this.statusNotice(I18n.tr((String)"Done uploading."));
                }
            }
            catch (SerialNotFoundException e) {
                if (portMenu.getItemCount() == 0) {
                    Editor.this.statusError(I18n.tr((String)"Serial port not selected."));
                } else if (Editor.this.serialPrompt()) {
                    this.run();
                } else {
                    Editor.this.statusNotice(I18n.tr((String)"Upload canceled."));
                }
            }
            catch (PreferencesMapException e) {
                Editor.this.statusError(I18n.format((String)I18n.tr((String)"Error while uploading: missing '{0}' configuration parameter"), (Object[])new Object[]{e.getMessage()}));
            }
            catch (RunnerException e) {
                Editor.this.status.unprogress();
                Editor.this.statusError((Exception)((Object)e));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Editor.this.populatePortMenu();
                avoidMultipleOperations = false;
            }
            Editor.this.status.unprogress();
            uploading = false;
            Editor.this.toolbar.deactivateExport();
            Editor.this.resumeOrCloseSerialMonitor();
            Editor.this.resumeOrCloseSerialPlotter();
            Editor.this.base.onBoardOrPortChange();
        }
    }

    class BuildHandler
    implements Runnable {
        private final boolean verbose;
        private final boolean saveHex;

        public BuildHandler() {
            this(false);
        }

        public BuildHandler(boolean verbose) {
            this(verbose, false);
        }

        public BuildHandler(boolean verbose, boolean saveHex) {
            this.verbose = verbose;
            this.saveHex = saveHex;
        }

        @Override
        public void run() {
            try {
                Editor.this.removeAllLineHighlights();
                Editor.this.sketchController.build(this.verbose, this.saveHex);
                Editor.this.statusNotice(I18n.tr((String)"Done compiling."));
            }
            catch (PreferencesMapException e) {
                Editor.this.statusError(I18n.format((String)I18n.tr((String)"Error while compiling: missing '{0}' configuration parameter"), (Object[])new Object[]{e.getMessage()}));
            }
            catch (Exception e) {
                Editor.this.status.unprogress();
                Editor.this.statusError(e);
            }
            Editor.this.status.unprogress();
            Editor.this.toolbar.deactivateRun();
            avoidMultipleOperations = false;
        }
    }

    class BoardPortJCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        private BoardPort port;

        public BoardPortJCheckBoxMenuItem(BoardPort port) {
            this.port = port;
            this.setText(this.toString());
            this.addActionListener(e -> {
                Editor.this.selectSerialPort(port.getAddress());
                Editor.this.base.onBoardOrPortChange();
            });
        }

        @Override
        public String toString() {
            String label = this.port.getLabel();
            if (this.port.getBoardName() != null && !this.port.getBoardName().isEmpty()) {
                label = label + " (" + this.port.getBoardName() + ")";
            }
            return label;
        }
    }

    private class FileDropHandler
    extends TransferHandler {
        private FileDropHandler() {
        }

        @Override
        public boolean canImport(JComponent dest, DataFlavor[] flavors) {
            return true;
        }

        @Override
        public boolean importData(JComponent src, Transferable transferable) {
            int successful = 0;
            try {
                DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File file : list) {
                        if (!Editor.this.sketchController.addFile(file)) continue;
                        ++successful;
                    }
                } else if (transferable.isDataFlavorSupported(uriListFlavor)) {
                    String[] pieces;
                    String data = (String)transferable.getTransferData(uriListFlavor);
                    for (String piece : pieces = PApplet.splitTokens((String)data, (String)"\r\n")) {
                        if (piece.startsWith("#")) continue;
                        String path = null;
                        if (piece.startsWith("file:///")) {
                            path = piece.substring(7);
                        } else if (piece.startsWith("file:/")) {
                            path = piece.substring(5);
                        }
                        if (!Editor.this.sketchController.addFile(new File(path))) continue;
                        ++successful;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            if (successful == 0) {
                Editor.this.statusError(I18n.tr((String)"No files were added to the sketch."));
            } else if (successful == 1) {
                Editor.this.statusNotice(I18n.tr((String)"One file added to the sketch."));
            } else {
                Editor.this.statusNotice(I18n.format((String)I18n.tr((String)"{0} files added to the sketch."), (Object[])new Object[]{successful}));
            }
            return true;
        }
    }

    private static class CanExportInSketchFolder
    implements Predicate<SketchController> {
        private CanExportInSketchFolder() {
        }

        @Override
        public boolean test(SketchController controller) {
            if (controller.isReadOnly()) {
                return false;
            }
            if (controller.getSketch().isModified()) {
                return PreferencesData.getBoolean((String)"editor.save_on_verify");
            }
            return true;
        }
    }

    private static class ShouldSaveIfModified
    implements Predicate<SketchController> {
        private ShouldSaveIfModified() {
        }

        @Override
        public boolean test(SketchController controller) {
            return PreferencesData.getBoolean((String)"editor.save_on_verify") && controller.getSketch().isModified() && !controller.isReadOnly();
        }
    }
}

